PROGRAM diff
!
!  Purpose: 
!    To test the effects of finite precision by differentiating
!    a function with 10 different step sizes, with both single
!    precision and double precision.  The test will be based on 
!    the function F(X) = 1./X.
! 
!  Record of revisions:
!       Date       Programmer          Description of change
!       ====       ==========          =====================
!     12/03/95    S. J. Chapman        Original code
!
IMPLICIT NONE

! Declare parameters
INTEGER, PARAMETER :: single = SELECTED_REAL_KIND(p=6,r=37)
INTEGER, PARAMETER :: double = SELECTED_REAL_KIND(p=13)

! List of local variables:
REAL(KIND=double) :: ans          ! True (analytic) answer
REAL(KIND=double) :: d_ans        ! Double precision answer
REAL(KIND=double) :: d_error      ! Double precision percent error
REAL(KIND=double) :: d_fx         ! Double precision F(x)
REAL(KIND=double) :: d_fxdx       ! Double precision F(x+dx)
REAL(KIND=double) :: d_dx         ! Step size
REAL(KIND=double) :: d_x =0.15D0  ! Location to evaluate dF(x)/dx
INTEGER :: i                      ! Index variable
REAL(KIND=single) :: s_ans        ! Single precision answer
REAL(KIND=single) :: s_error      ! Single precision percent error
REAL(KIND=single) :: s_fx         ! Single precision F(x)
REAL(KIND=single) :: s_fxdx       ! Single precision F(x+dx)
REAL(KIND=single) :: s_dx         ! Step size
REAL(KIND=single) :: s_x =0.15E0  ! Location to evaluate dF(x)/dx

! Print headings.
WRITE (*,1)
1 FORMAT (1X,'    DX       TRUE ANS     SP ANS          DP ANS  ', &
             '         SP ERR   DP ERR  ')
 
! Calculate analytic solution at x=0.15.
ans = - ( 1.D0 / d_x**2 )
    
! Calculate answer from definition of differentiation
step_size: DO i = 1, 10 
 
   ! Get delta x.
   s_dx = 1.0 / 10.0**i
   d_dx = 1.D0 / 10.D0**i
 
   ! Calculate single precision answer.
   s_fxdx = 1. / (s_x + s_dx )   
   s_fx   = 1./ s_x
   s_ans   = ( s_fxdx - s_fx ) / s_dx
 
   ! Calculate single precision error, in percent.
   s_error = ( s_ans - REAL(ans) ) / REAL(ans) * 100.
 
   ! Calculate double precision answer.
   d_fxdx = 1.D0 / ( d_x + d_dx )   
   d_fx   = 1.D0 / d_x 
   d_ans   = ( d_fxdx - d_fx ) / d_dx

   ! Calculate double precision error, in percent.
   d_error = ( d_ans - ans ) / ans * 100.
 
   ! Tell user.
   WRITE (*,100) d_dx, ans, s_ans, d_ans, s_error, d_error
   100 FORMAT (1X, ES10.3, F12.7, F12.7, ES22.14, F9.3, F9.3)
 
END DO step_size
 
END PROGRAM
